implementation module controlinternal


//	Clean Object I/O library, version 1.0.1


import	StdBool, StdList, StdMisc
import	StdIOCommon, StdPicture
import	ospicture
import	commondef, controldraw, controllayout, controlpos, controlvalidate, windowaccess, windowclipstate, wstateaccess


controlinternalFatalError :: String String -> .x
controlinternalFatalError function error
	= FatalError function "controlinternal" error


//	General occurrence tests on Id.

maybeRemoveCheck :: !(Maybe x) [x] -> (!Bool,![x])	| Eq x
maybeRemoveCheck maybe ids
	| isJust maybe
	= RemoveCheck (fromJust maybe) ids
	= (False,ids)

removeOnIdOfPair :: Id ![(Id,x)] -> (!Bool,(Id,x),![(Id,x)])
removeOnIdOfPair id id_args
	= Remove (\(id`,_)->id`==id) undef id_args

removeOnIdOfTriple :: Id ![(Id,x,y)] -> (!Bool,(Id,x,y),![(Id,x,y)])
removeOnIdOfTriple id id_args
	= Remove (\(id`,_,_)->id`==id) undef id_args


/*	Calculate the intersection of the given RgnHandle with the content of a CompoundControl.
*/
intersectRgnContent :: !OSWindowMetrics !OSRgnHandle !CompoundInfo !Point !Size !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
intersectRgnContent wMetrics clipRgn info itemPos itemSize tb
	= IntersectRgnRect clipRgn contentRect tb
where
	hasHScroll		= isJust info.compoundHScroll
	hasVScroll		= isJust info.compoundVScroll
	itemRect		= PosSizeToRect itemPos itemSize
	contentRect		= getCompoundContentRect wMetrics hasHScroll hasVScroll itemRect

/*	Calculate the intersection of the given Rect with the content of a CompoundControl.
*/
intersectRectContent :: !OSWindowMetrics !Rect !CompoundInfo !Point !Size -> Rect
intersectRectContent wMetrics clipRect info itemPos itemSize
	= IntersectRects clipRect contentRect
where
	hasHScroll		= isJust info.compoundHScroll
	hasVScroll		= isJust info.compoundVScroll
	itemRect		= PosSizeToRect itemPos itemSize
	contentRect		= getCompoundContentRect wMetrics hasHScroll hasVScroll itemRect


/*	Enable the controls and provide proper feedback.
	The [Id] argument contains the Ids of the controls that should be enabled.
	The Boolean argument controls the new SelectState. 
		If the Boolean argument is False, then SelectState is the new SelectState of the indicated controls.
		If the Boolean argument is True,  then SelectState is the new SelectState of the indicated controls 
										  and  all other controls. 
*/
enablecontrols :: ![Id] !Bool !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
enablecontrols ids overrule wPtr wH=:{whItems`,whShow`,whSelect`,whSize`,whDefaultId`} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (SizeToRect whSize`)
	# (itemHs,(_,tb))		= setAllWElements (enableWItemHandle` wMetrics wPtr whDefaultId` overrule whSelect` whShow` clipRect) whItems` (ids,tb)
	= ({wH & whItems`=itemHs},tb)
where
	enableWItemHandle` :: !OSWindowMetrics !OSWindowPtr !(Maybe Id) !Bool !Bool !Bool !Rect !WItemHandle` !(![Id],!*OSToolbox)
																						-> (!WItemHandle`,!(![Id],!*OSToolbox))
	
	enableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`} (ids,tb)
		| systemControl
			# (found,ids)	= maybeRemoveCheck itemH.wItemId` ids
			| found
				= ({itemH & wItemSelect`=True},(ids,systemOSAction contextSelect tb))
			| overrule
				= (itemH,(ids,systemOSAction (contextSelect && itemSelect) tb))
			// otherwise
				= (itemH,(ids,tb))
	where
		itemPtr		= itemH.wItemPtr`
		itemSelect	= itemH.wItemSelect`
		radioItems	= (getWItemRadioInfo` itemH.wItemInfo`).radioItems`
		checkItems	= (getWItemCheckInfo` itemH.wItemInfo`).checkItems`
		(systemControl,systemOSAction)
					= case wItemKind` of
						IsRadioControl	-> (True,\able->StateMap2 (\{radioItemPtr`}->OSsetRadioControlSelect wPtr radioItemPtr` clipRect able) radioItems)
						IsCheckControl	-> (True,\able->StateMap2 (\{checkItemPtr`}->OSsetCheckControlSelect wPtr checkItemPtr` clipRect able) checkItems)
  						IsPopUpControl	-> (True,OSsetPopUpControlSelect  wPtr itemPtr clipRect)
  						IsSliderControl	-> (True,OSsetSliderControlSelect wPtr itemPtr clipRect)
  						IsTextControl	-> (True,OSsetTextControlSelect   wPtr itemPtr clipRect)
  						IsEditControl	-> (True,OSsetEditControlSelect   wPtr itemPtr clipRect)
  						IsButtonControl	-> (True,OSsetButtonControlSelect wPtr itemPtr clipRect)
  						_				-> (False,undef)
	
	enableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`} (ids,tb)
		| customControl
			# (found,ids)	= maybeRemoveCheck itemH.wItemId` ids
			| found
				# itemH		= {itemH & wItemSelect`=True}
				# tb		= customOSAction contextSelect tb
				# (itemH,tb)= customDraw contextSelect wPtr itemH tb
				= (itemH,(ids,tb))
			| overrule
				# select	= contextSelect && itemSelect
				# (itemH,tb)= customDraw select wPtr itemH tb
				= (itemH,(ids,customOSAction select tb))
			// otherwise
				= (itemH,(ids,tb))
	where
		itemPtr				= itemH.wItemPtr`
		itemSelect			= itemH.wItemSelect`
		(customControl,customDraw,customOSAction)
							= case wItemKind` of
		  						IsCustomButtonControl	-> (True,drawCustomButtonLook,OSsetCustomButtonControlSelect wPtr itemPtr clipRect)
		  						IsCustomControl			-> (True,drawCustomLook,      OSsetCustomControlSelect       wPtr itemPtr clipRect)
		  						_						-> (False,undef,undef)
	
	enableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`=IsCompoundControl} (ids,tb)
		# (found,ids)			= maybeRemoveCheck itemH.wItemId` ids
		| found
			# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
			# (itemH,tb)		= drawCompoundLook contextSelect wPtr itemH tb
			# (itemHs,(ids,tb))	= setAllWElements (enableWItemHandle` wMetrics wPtr defId True contextSelect contextShow1 clipRect1) itemH.wItems` (ids,tb)
			# tb				= OSsetCompoundSelect wPtr itemPtr clipRect scrollInfo contextSelect tb
			  itemH				= {itemH & wItemSelect`=True,wItems`=itemHs}
			= (itemH,(ids,tb))
		| overrule
			# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
			# (itemH,tb)		= drawCompoundLook contextSelect1 wPtr itemH tb
			# (itemHs,(ids,tb))	= setAllWElements (enableWItemHandle` wMetrics wPtr defId overrule contextSelect1 contextShow1 clipRect1) itemH.wItems` (ids,tb)
			# tb				= OSsetCompoundSelect wPtr itemPtr clipRect scrollInfo contextSelect1 tb
			  itemH				= {itemH & wItems`=itemHs}
			= (itemH,(ids,tb))
		// otherwise
			# (itemHs,(ids,tb))	= setAllWElements (enableWItemHandle` wMetrics wPtr defId overrule contextSelect1 contextShow1 clipRect1) itemH.wItems` (ids,tb)
			  itemH				= {itemH & wItems`=itemHs}
			= (itemH,(ids,tb))
	where
		itemPtr					= itemH.wItemPtr`
		itemSelect				= itemH.wItemSelect`
		info					= getWItemCompoundInfo` itemH.wItemInfo`
		scrollInfo				= (isJust info.compoundHScroll,isJust info.compoundVScroll)
		itemSize				= itemH.wItemSize`
		contextSelect1			= contextSelect && itemSelect
		contextShow1			= contextShow && itemH.wItemShow`
		clipRect1				= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemSize
	
	enableWItemHandle` _ _ _ _ _ _ _ itemH=:{wItemKind`=IsOtherControl _} (ids,tb)
		# (found,ids)	= maybeRemoveCheck itemH.wItemId` ids
		| found
		= ({itemH & wItemSelect`=True},(ids,tb))
		= (itemH,(ids,tb))


/*	Disable the controls and provide proper feedback.
	The [Id] argument contains the Ids of the controls that should be (dis/en)abled.
	The Boolean argument controls the new SelectState. 
		If the Boolean argument is False, then SelectState is the new SelectState of the indicated controls.
		If the Boolean argument is True,  then SelectState is the new SelectState of the indicated controls 
										  and  all other controls. 
*/
disablecontrols :: ![Id] !Bool !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
disablecontrols ids overrule wPtr wH=:{whItems`,whShow`,whSelect`,whSize`,whDefaultId`} tb
	# (wMetrics,tb)		= OSDefaultWindowMetrics tb
	  clipRect			= getWindowContentRect wMetrics False False (SizeToRect whSize`)
	# (itemHs,(_,tb))	= setAllWElements (disableWItemHandle` wMetrics wPtr whDefaultId` overrule whSelect` whShow` clipRect) whItems` (ids,tb)
	= ({wH & whItems`=itemHs},tb)
where
	disableWItemHandle` :: !OSWindowMetrics !OSWindowPtr !(Maybe Id) !Bool !Bool !Bool !Rect !WItemHandle` !(![Id],!*OSToolbox)
																						 -> (!WItemHandle`,!(![Id],!*OSToolbox))
	
	disableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`} (ids,tb)
		| systemControl
			# (found,ids)	= maybeRemoveCheck itemH.wItemId` ids
			| found
				= ({itemH & wItemSelect`=False},(ids,systemOSAction False tb))
			| overrule
				= (itemH,(ids,systemOSAction (contextSelect && itemSelect) tb))
			// otherwise
				= (itemH,(ids,tb))
	where
		itemPtr		= itemH.wItemPtr`
		itemSelect	= itemH.wItemSelect`
		radioItems	= (getWItemRadioInfo` itemH.wItemInfo`).radioItems`
		checkItems	= (getWItemCheckInfo` itemH.wItemInfo`).checkItems`
		(systemControl,systemOSAction)
					= case wItemKind` of
						IsRadioControl	-> (True,\able->StateMap2 (\{radioItemPtr`}->OSsetRadioControlSelect wPtr radioItemPtr` clipRect able) radioItems)
						IsCheckControl	-> (True,\able->StateMap2 (\{checkItemPtr`}->OSsetCheckControlSelect wPtr checkItemPtr` clipRect able) checkItems)
						IsPopUpControl	-> (True,OSsetPopUpControlSelect  wPtr itemPtr clipRect)
						IsSliderControl	-> (True,OSsetSliderControlSelect wPtr itemPtr clipRect)
						IsTextControl	-> (True,OSsetTextControlSelect   wPtr itemPtr clipRect)
						IsEditControl	-> (True,OSsetEditControlSelect   wPtr itemPtr clipRect)
						IsButtonControl	-> (True,OSsetButtonControlSelect wPtr itemPtr clipRect)
						_				-> (False,undef)
	
	disableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`} (ids,tb)
		| customControl
			# (found,ids)	= maybeRemoveCheck itemH.wItemId` ids
			| found
				# itemH		= {itemH & wItemSelect`=False}
				# tb		= customOSAction False tb
				# (itemH,tb)= customDraw False wPtr itemH tb
				= (itemH,(ids,tb))
			| overrule
				# select	= contextSelect && itemSelect
				# (itemH,tb)= customDraw select wPtr itemH tb
				= (itemH,(ids,customOSAction select tb))
			// otherwise
				= (itemH,(ids,tb))
	where
		itemPtr				= itemH.wItemPtr`
		itemSelect			= itemH.wItemSelect`
		(customControl,customDraw,customOSAction)
							= case wItemKind` of
								IsCustomButtonControl	-> (True,drawCustomButtonLook,OSsetCustomButtonControlSelect wPtr itemPtr clipRect)
								IsCustomControl			-> (True,drawCustomLook,      OSsetCustomControlSelect       wPtr itemPtr clipRect)
								_						-> (False,undef,undef)
	
	disableWItemHandle` wMetrics wPtr defId overrule contextSelect contextShow clipRect itemH=:{wItemKind`=IsCompoundControl} (ids,tb)
		# (found,ids)			= maybeRemoveCheck itemH.wItemId` ids
		| found
			# itemH				= {itemH & wItemSelect`=False}
			# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
			# (itemH,tb)		= drawCompoundLook False wPtr itemH tb
			# (itemHs,(ids,tb))	= setAllWElements (disableWItemHandle` wMetrics wPtr defId True False contextShow1 clipRect1) itemH.wItems` (ids,tb)
			# tb				= OSsetCompoundSelect wPtr itemPtr clipRect scrollInfo False tb
			  itemH				= {itemH & wItems`=itemHs}
			= (itemH,(ids,tb))
		| overrule
			# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
			# (itemH,tb)		= drawCompoundLook contextSelect1 wPtr itemH tb
			# (itemHs,(ids,tb))	= setAllWElements (disableWItemHandle` wMetrics wPtr defId overrule contextSelect1 contextShow1 clipRect1) itemH.wItems` (ids,tb)
			# tb				= OSsetCompoundSelect wPtr itemPtr clipRect scrollInfo contextSelect1 tb
			  itemH				= {itemH & wItems`=itemHs}
			= (itemH,(ids,tb))
		// otherwise
			# (itemHs,(ids,tb))	= setAllWElements (disableWItemHandle` wMetrics wPtr defId overrule contextSelect1 contextShow1 clipRect1) itemH.wItems` (ids,tb)
			  itemH				= {itemH & wItems`=itemHs}
			= (itemH,(ids,tb))
	where
		itemPtr					= itemH.wItemPtr`
		itemSelect				= itemH.wItemSelect`
		itemSize				= itemH.wItemSize`
		contextSelect1			= contextSelect && itemSelect
		contextShow1			= contextShow && itemH.wItemShow`
		info					= getWItemCompoundInfo` itemH.wItemInfo`
		scrollInfo				= (isJust info.compoundHScroll,isJust info.compoundVScroll)
		clipRect1				= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemSize
	
	disableWItemHandle` _ _ _ _ _ _ _ itemH=:{wItemKind`=IsOtherControl _} (ids,tb)
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		| found
		= ({itemH & wItemSelect`=False},(ids,tb))
		= (itemH,(ids,tb))


//	Set the show state of the controls and provide proper feedback.

setcontrolsshowstate :: ![Id] !Bool !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
setcontrolsshowstate ids itemsShow wPtr wH=:{whItems`,whSelect`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	  contextShow			= True
	  contextSelect			= if whSelect` Able Unable
	# (_,itemHs,tb)			= setWElements (setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect) ids whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	setWItemShowStates :: !OSWindowMetrics !OSWindowPtr !Bool !Bool !SelectState !Rect ![Id] !WItemHandle` !*OSToolbox
																				   -> (![Id],!WItemHandle`,!*OSToolbox)
	
	setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect ids itemH=:{wItemKind`=IsRadioControl} tb
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		| not found
		= (ids,itemH,tb)
		# osShow			= contextShow && itemsShow
		  itemH				= {itemH & wItemShow`=itemsShow}
		  info				= getWItemRadioInfo` itemH.wItemInfo`
		# tb				= StateMap2 (\{radioItemPtr`} tb->OSsetRadioControlShow wPtr radioItemPtr` clipRect osShow tb) info.radioItems` tb
		= (ids,itemH,tb)
	
	setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect ids itemH=:{wItemKind`=IsCheckControl} tb
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		| not found
		= (ids,itemH,tb)
		# osShow			= contextShow && itemsShow
		  itemH				= {itemH & wItemShow`=itemsShow}
		  info				= getWItemCheckInfo` itemH.wItemInfo`
		# tb				= StateMap2 (\{checkItemPtr`} tb->OSsetCheckControlShow wPtr checkItemPtr` clipRect osShow tb) info.checkItems` tb
		= (ids,itemH,tb)
	
	setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect ids itemH=:{wItemKind`} tb
		| isMember wItemKind` [IsPopUpControl,IsSliderControl,IsTextControl,IsEditControl,IsButtonControl,IsCustomControl,IsCustomButtonControl]
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		| not found
		= (ids,itemH,tb)
		# osShow			= contextShow && itemsShow
		  itemH				= {itemH & wItemShow`=itemsShow}
		  osAction			= case wItemKind` of
		  						IsPopUpControl			-> OSsetPopUpControlShow
		  						IsSliderControl			-> OSsetSliderControlShow
		  						IsTextControl			-> OSsetTextControlShow
		  						IsEditControl			-> OSsetEditControlShow
		  						IsButtonControl			-> OSsetButtonControlShow
		  						IsCustomButtonControl	-> OSsetCustomButtonControlShow
		  						IsCustomControl			-> OSsetCustomControlShow
		  						_						-> controlinternalFatalError "setWItemShowStates" "unexpected ControlKind alternative"
		# tb				= osAction wPtr itemH.wItemPtr` clipRect osShow tb
		= (ids,itemH,tb)
	
	setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect ids itemH=:{wItemKind`=IsCompoundControl} tb
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		# (ids,itemHs,tb)	= setWElements (setWItemShowStates wMetrics wPtr itemsShow contextShow1 contextSelect1 clipRect1) ids itemH.wItems` tb
		  itemH				= {itemH & wItems`=itemHs}
		| not found
		= (ids,itemH,tb)
		# itemH				= {itemH & wItemShow`=itemsShow}
		# tb				= OSsetCompoundShow wPtr itemH.wItemPtr` clipRect itemsShow tb
		= (ids,itemH,tb)
	where
		contextSelect1		= if (enabled contextSelect) (if itemH.wItemSelect` Able Unable) contextSelect
		contextShow1		= contextShow && itemH.wItemShow`
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		itemSize			= itemH.wItemSize`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemSize
	
	setWItemShowStates wMetrics wPtr itemsShow contextShow contextSelect clipRect ids itemH=:{wItemKind`=IsOtherControl _} tb
		# (found,ids)		= maybeRemoveCheck itemH.wItemId` ids
		| not found
		= (ids,itemH,tb)
		# itemSelect		= if (enabled contextSelect) (if itemH.wItemSelect` Able Unable) contextSelect
		  itemSelected		= enabled itemSelect
		  itemH				= {itemH & wItemSelect`=itemSelected}
		= (ids,itemH,tb)


//	Set the MarkState of the controls and provide proper feedback.

setcontrolsmarkstate :: !Id !MarkState ![Index] !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
setcontrolsmarkstate id mark indexs wPtr wH=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElement (setWItemMarks wMetrics wPtr mark clipRect indexs) id whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	setWItemMarks :: !OSWindowMetrics !OSWindowPtr !MarkState !Rect ![Index] !Id !WItemHandle` !*OSToolbox -> (!Bool,!WItemHandle`,!*OSToolbox)
	setWItemMarks wMetrics wPtr mark clipRect indexs id itemH=:{wItemKind`=IsCompoundControl} tb
		# (found,itemHs,tb)	= setWElement (setWItemMarks wMetrics wPtr mark clipRect1 indexs) id itemH.wItems` tb
		= (found,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
	setWItemMarks wMetrics wPtr mark clipRect indexs id itemH=:{wItemKind`} tb
		| wItemKind`<>IsCheckControl || not (identifyMaybeId id itemH.wItemId`)
		= (False,itemH,tb)
		# info				= getWItemCheckInfo` itemH.wItemInfo`
		  checkItems		= info.checkItems`
		  nrCheckItems		= length checkItems
		  indexs			= filter (\index->IsBetween index 1 nrCheckItems) indexs
		| isEmpty indexs
		= (True,itemH,tb)
		# (checkItems,tb)	= StateMap2 (setCheckMark wPtr clipRect mark) indexs (checkItems,tb)
		  itemH				= {itemH & wItemInfo`=CheckInfo` {info & checkItems`=checkItems}}
		= (True,itemH,tb)
	where
		setCheckMark :: !OSWindowPtr !Rect !MarkState !Index !(![CheckItemInfo`],!*OSToolbox) -> (![CheckItemInfo`],!*OSToolbox)
		setCheckMark wPtr clipRect mark index (checkItems,tb)
			# (before,[item:after])	= Split (index-1) checkItems
			  (title,_)				= item.checkItem`
			  checkItems			= before++[{item & checkItem`=(title,mark)}:after]
			= (checkItems,OSsetCheckControl wPtr item.checkItemPtr` clipRect (marked mark) tb)
/* Mac oswindow version.
OSsetCheckControl :: !OSWindowPtr !OSWindowPtr !Rect !Bool !*OSToolbox -> *OSToolbox
OSsetCheckControl parentWindow cPtr clipRect check tb
	# (visRgn, tb)			= WindowGetVisRgn parentWindow tb
	# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
	# (port,rgn,font,tb)	= openDrawing parentWindow tb
	# tb					= QSetClip clipRgn tb
	# tb					= SetCtlValue cPtr (if check 1 0) tb
	# tb					= closeDrawing port font rgn [rgn,clipRgn] tb
	= tb
*/

//	Set the text of the controls and provide proper feedback.

setcontroltexts :: ![(Id,String)] !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
setcontroltexts id_texts wPtr wH`=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElements (setControlText wMetrics wPtr True clipRect) id_texts whItems` tb
	= ({wH` & whItems`=itemHs},tb)
where
	setControlText :: !OSWindowMetrics !OSWindowPtr !Bool !Rect ![(Id,String)] !WItemHandle` !*OSToolbox
															-> (![(Id,String)],!WItemHandle`,!*OSToolbox)
	
	setControlText wMetrics wPtr shownContext clipRect id_texts itemH=:{wItemKind`=IsCompoundControl} tb
		# (id_texts,itemHs,tb)	= setWElements (setControlText wMetrics wPtr shownContext1 clipRect1) id_texts itemH.wItems` tb
		= (id_texts,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
		shownContext1		= shownContext && itemH.wItemShow`
	
	setControlText wMetrics wPtr shownContext clipRect id_texts itemH=:{wItemKind`=IsEditControl} tb
		| isNothing itemH.wItemId`
		= (id_texts,itemH,tb)
		# id						= fromJust itemH.wItemId`
		  (found,id_text,id_texts)	= removeOnIdOfPair id id_texts
		| not found
		= (id_texts,itemH,tb)
		# shownContext1				= shownContext && itemH.wItemShow`
		  (_,text)					= id_text
		  editInfo					= getWItemEditInfo` itemH.wItemInfo`
		  itemH						= {itemH & wItemInfo`=EditInfo` {editInfo & editInfoText=text}}
		  itemRect					= PosSizeToRect itemH.wItemPos` itemH.wItemSize`
		  tb						= OSsetEditControlText wPtr itemH.wItemPtr` clipRect itemRect shownContext1 text tb
		= (id_texts,itemH,tb)
	/* Mac oswindow version.
		OSsetEditControlText :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String !*OSToolbox -> *OSToolbox
		OSsetEditControlText parentWindow hTE clipRect itemRect text shown tb
			# (visRgn, tb)			= WindowGetVisRgn parentWindow tb
			# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
			# (clipRgn1,tb)			= setEditRgnRect clipRgn shown itemRect tb
			# (port,rgn,font,tb)	= openDrawing parentWindow tb
			# tb					= QSetClip clipRgn1 tb
			# tb					= setEditText text hTE itemRect tb
			# tb					= closeDrawing port font rgn [rgn,clipRgn,clipRgn1] tb
			= tb
		where
			setEditRgnRect :: !RgnHandle !Bool !Rect !*OSToolbox -> (!RgnHandle,!*OSToolbox)
			setEditRgnRect clipRgn shown itemRect tb
				# addEditRect		= if shown ZeroRect itemRect
				# (rgn,tb)			= QNewRgn tb
				# tb				= QRectRgn rgn addEditRect tb
				= QDiffRgn clipRgn rgn rgn tb
			
			setEditText :: !String !TEHandle !Rect !*OSToolbox -> *OSToolbox
			setEditText text hTE itemRect tb
				# tb				= TESetSelect 0 32767 hTE tb
				# tb				= TEDelete hTE tb
				# tb				= TESetText text hTE tb
				# tb				= TESetSelect 0 0 hTE tb
				= TEUpdate itemRect hTE tb
	*/
	
	setControlText wMetrics wPtr shownContext clipRect id_texts itemH=:{wItemKind`=IsTextControl} tb
		| isNothing itemH.wItemId`
		= (id_texts,itemH,tb)
		# id						= fromJust itemH.wItemId`
		  (found,id_text,id_texts)	= removeOnIdOfPair id id_texts
		| not found
		= (id_texts,itemH,tb)
		# (_,text)					= id_text
		  shownContext1				= shownContext && itemH.wItemShow`
		  textInfo					= getWItemTextInfo` itemH.wItemInfo`
		  itemH						= {itemH & wItemInfo`=TextInfo` {textInfo & textInfoText=text}}
		  itemRect					= PosSizeToRect itemH.wItemPos` itemH.wItemSize`
		  tb						= OSsetTextControlText wPtr itemH.wItemPtr` clipRect itemRect shownContext1 text tb
		= (id_texts,itemH,tb)
	/* Mac oswindow version.
	OSsetTextControlText :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Bool !String !*OSToolbox -> *OSToolbox
	OSsetTextControlText parentWindow tPtr clipRect itemRect show text tb
		| not show
		= tb
		# (visRgn, tb)			= WindowGetVisRgn parentWindow parentWindow tb
		# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
		# (port,rgn,font,tb)	= openDrawing parentWindow tb
		# tb					= QSetClip clipRgn tb
		# tb					= TETextBox text itemRect TEFlushDefault tb
		# tb					= closeDrawing port font rgn [rgn,clipRgn] tb
		= tb
	*/
	
	setControlText wMetrics wPtr _ clipRect id_texts itemH=:{wItemKind`=IsButtonControl} tb
		| isNothing itemH.wItemId`
		= (id_texts,itemH,tb)
		# id						= fromJust itemH.wItemId`
		  (found,id_text,id_texts)	= removeOnIdOfPair id id_texts
		| not found
		= (id_texts,itemH,tb)
		# (_,text)					= id_text
		  buttonInfo				= getWItemButtonInfo` itemH.wItemInfo`
		  itemH						= {itemH & wItemInfo`=ButtonInfo` {buttonInfo & buttonInfoText=text}}
		# tb						= OSsetButtonControlText wPtr itemH.wItemPtr` clipRect (validateControlTitle text) tb
		= (id_texts,itemH,tb)
	/* Mac oswindow version.
	OSsetButtonControlText :: !OSWindowPtr !OSWindowPtr !Rect !String !*OSToolbox -> *OSToolbox
	OSsetButtonControlText parentWindow buttonPtr clipRect text tb
		# (visRgn, tb)			= WindowGetVisRgn parentWindow parentWindow tb
		# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
		# (port,rgn,font,tb)	= openDrawing parentWindow tb
		# tb					= QSetClip clipRgn tb
		# tb					= SetCTitle buttonPtr text tb
		# tb					= closeDrawing port font rgn [rgn,clipRgn] tb
		= tb
	*/
	
	setControlText _ _ _ _ id_texts itemH tb
		= (id_texts,itemH,tb)


//	Set the cursor position of an EditControl, and handle proper feedback.

seteditcontrolcursor :: !Id !Int !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
seteditcontrolcursor id pos wPtr wH`=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElement (setEditCursor wMetrics wPtr True clipRect pos) id whItems` tb
	= ({wH` & whItems`=itemHs},tb)
where
	setEditCursor :: !OSWindowMetrics !OSWindowPtr !Bool !Rect !Int !Id !WItemHandle` !*OSToolbox -> (!Bool,!WItemHandle`,!*OSToolbox)
	
	setEditCursor wMetrics wPtr shownContext clipRect pos id itemH=:{wItemKind`=IsCompoundControl} tb
		# (found,itemHs,tb)	= setWElement (setEditCursor wMetrics wPtr shownContext1 clipRect1 pos) id itemH.wItems` tb
		= (found,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
		shownContext1		= shownContext && itemH.wItemShow`
	
	setEditCursor wMetrics wPtr shownContext clipRect pos id itemH=:{wItemKind`=IsEditControl} tb
		| isNothing itemH.wItemId`
		= (False,itemH,tb)
		# itemId			= fromJust itemH.wItemId`
		| itemId<>id
		= (False,itemH,tb)
		# itemRect			= PosSizeToRect itemH.wItemPos` itemH.wItemSize`
		# tb				= OSsetEditControlCursor wPtr itemH.wItemPtr` clipRect itemRect pos tb
		= (True,itemH,tb)
	/* Mac oswindow version.
	OSsetEditControlCursor :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int !*OSToolbox -> *OSToolbox
	OSsetEditControlCursor parentWindow hTE clipRect itemRect pos tb
		# (visRgn, tb)		= WindowGetVisRgn parentWindow tb
		# (clipRgn,tb)		= IntersectRgnRect visRgn clipRect tb
		# (port,rgn,font,tb)= openDrawing parentWindow tb
		# tb				= QSetClip clipRgn tb
		# tb				= TESetSelect pos pos hTE tb
		# tb				= closeDrawing port font rgn [rgn,clipRgn] tb
		= tb
	*/
	
	setEditCursor _ _ _ _ _ _ itemH tb
		= (False,itemH,tb)


//	Set the look of a control, and handle proper feedback.

setcontrolslook :: ![(Id,Bool,Look)] !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
setcontrolslook looks wPtr wH=:{whItems`,whAtts`,whSelect`,whDefaultId`,whSize`} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (SizeToRect whSize`)
	  resizeable			= Contains isWindowResize` whAtts`
	# (_,itemHs,tb)			= setWElements (setWItemLook wMetrics wPtr whSelect` True resizeable whDefaultId` clipRect) looks whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	setWItemLook :: !OSWindowMetrics !OSWindowPtr !Bool !Bool !Bool (Maybe Id) !Rect ![(Id,Bool,Look)] !WItemHandle` !*OSToolbox
																				 -> (![(Id,Bool,Look)],!WItemHandle`,!*OSToolbox)
	
	setWItemLook wMetrics wPtr ableContext shownContext resizeable defId clipRect looks itemH=:{wItemId`,wItemKind`=IsCompoundControl,wItemSize`} tb
		# (found,look,looks)= if (isJust wItemId`) (removeOnIdOfTriple (fromJust wItemId`) looks) (False,undef,looks)
		# (looks,itemHs,tb)	= setWElements (setWItemLook wMetrics wPtr ableContext1 shownContext1 resizeable defId clipRect1) looks itemH.wItems` tb
		  itemH				= {itemH & wItems`=itemHs}
		| not found
		= (looks,itemH,tb)
		# (_,redraw,cLook)	= look
		  info				= {info & compoundLookInfo=Just {compoundLookInfo & compoundLook={lookFun=cLook,lookPen=pen}}}
		  itemH				= {itemH & wItemInfo`=CompoundInfo` info}
		| not redraw || not shownContext1
		= (looks,itemH,tb)
		# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
		# (itemH,tb)		= drawCompoundLook ableContext1 wPtr itemH tb
		= (looks,itemH,tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		hasHScroll			= isJust info.compoundHScroll
		hasVScroll			= isJust info.compoundVScroll
		hasLook				= isJust info.compoundLookInfo
		compoundLookInfo	= fromJust info.compoundLookInfo
		pen					= if hasLook compoundLookInfo.compoundLook.lookPen defaultPen
		itemRect			= PosSizeToRect itemH.wItemPos` wItemSize`
		contentRect			= getCompoundContentRect wMetrics hasHScroll hasVScroll itemRect
		clipRect1			= IntersectRects clipRect contentRect
		ableContext1		= ableContext  && itemH.wItemSelect`
		shownContext1		= shownContext && itemH.wItemShow`
	
	setWItemLook wMetrics wPtr ableContext shownContext resizeable defId clipRect looks itemH=:{wItemId`,wItemKind`=IsCustomButtonControl} tb
		# (found,look,looks)= if (isJust wItemId`) (removeOnIdOfTriple (fromJust wItemId`) looks) (False,undef,looks)
		| not found
		= (looks,itemH,tb)
		# (_,redraw,cLook)	= look
		  info				= {info & cButtonInfoLook={itemLook & lookFun=cLook}}
		  itemH				= {itemH & wItemInfo`=CustomButtonInfo` info}
		| not redraw || not shownContext1
		= (looks,itemH,tb)
		# (itemH,tb)		= drawCustomButtonLook ableContext1 wPtr itemH tb
		= (looks,itemH,tb)
	where
		info				= getWItemCustomButtonInfo` itemH.wItemInfo`
		itemLook			= info.cButtonInfoLook
		ableContext1		= ableContext  && itemH.wItemSelect`
		shownContext1		= shownContext && itemH.wItemShow`
	
	setWItemLook wMetrics wPtr ableContext shownContext resizeable defId clipRect looks itemH=:{wItemId`,wItemKind`=IsCustomControl} tb
		# (found,look,looks)= if (isJust wItemId`) (removeOnIdOfTriple (fromJust wItemId`) looks) (False,undef,looks)
		| not found
		= (looks,itemH,tb)
		# (_,redraw,cLook)	= look
		# info				= {info & customInfoLook={itemLook & lookFun=cLook}}
		# itemH				= {itemH & wItemInfo`=CustomInfo` info}
		| not redraw || not shownContext1
		= (looks,itemH,tb)
		# (itemH,tb)		= drawCustomLook ableContext1 wPtr itemH tb
		= (looks,itemH,tb)
	where
		info				= getWItemCustomInfo` itemH.wItemInfo`
		itemLook			= info.customInfoLook
		ableContext1		= ableContext  && itemH.wItemSelect`
		shownContext1		= shownContext && itemH.wItemShow`
	
	setWItemLook _ _ _ _ _ _ _ looks itemH=:{wItemId`} tb
		# (_,_,looks)		= if (isJust wItemId`) (removeOnIdOfTriple (fromJust wItemId`) looks) (False,undef,looks)
		= (looks,itemH,tb)


//	Draw in a customised control.

drawincontrol :: !Id ![DrawFunction] !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
drawincontrol controlId drawFs wPtr wH=:{whItems`,whAtts`,whDefaultId`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	  resizeable			= Contains isWindowResize` whAtts`
	# (_,itemHs,tb)			= setWElement (drawInWItem wMetrics wPtr resizeable whDefaultId` clipRect drawFs) controlId whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	drawInWItem :: !OSWindowMetrics !OSWindowPtr Bool (Maybe Id) !Rect ![DrawFunction] !Id !WItemHandle` !*OSToolbox
																				 -> (!Bool,!WItemHandle`,!*OSToolbox)
	
	drawInWItem wMetrics wPtr resizeable defId clipRect drawFs id itemH=:{wItemId`,wItemPtr`,wItemKind`=IsCompoundControl} tb
		| not (identifyMaybeId id wItemId`)
			# (found,itemHs,tb)	= setWElement (drawInWItem wMetrics wPtr resizeable defId clipRect1 drawFs) id itemH.wItems` tb
			= (found,{itemH & wItems`=itemHs},tb)
		| not hasCompoundLookInfo
			= (True,itemH,tb)
		# (itemH,tb)		= validateCompoundClipState` wPtr defId itemH tb
		# (itemH,tb)		= drawInCompound wPtr drawFs itemH tb
		= (True,itemH,tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		hasHScroll			= isJust info.compoundHScroll
		hasVScroll			= isJust info.compoundVScroll
		hasCompoundLookInfo	= isJust info.compoundLookInfo
		itemPos				= itemH.wItemPos`
		itemSize			= itemH.wItemSize`
		itemRect			= PosSizeToRect itemPos itemSize
		contentRect			= getCompoundContentRect wMetrics hasHScroll hasVScroll itemRect
		clipRect1			= IntersectRects clipRect contentRect
	
	drawInWItem _ wPtr _ _ _ drawFs id itemH=:{wItemId`,wItemKind`=IsCustomButtonControl} tb
		| not (identifyMaybeId id wItemId`)
		= (False,itemH,tb)
		# (itemH,tb)		= drawInCustomButton wPtr drawFs itemH tb
		= (True,itemH,tb)
	
	drawInWItem _ wPtr _ _ _ drawFs id itemH=:{wItemId`,wItemKind`=IsCustomControl} tb
		| not (identifyMaybeId id wItemId`)
		= (False,itemH,tb)
		# (itemH,tb)		= drawInCustom wPtr drawFs itemH tb
		= (True,itemH,tb)
	
	drawInWItem _ _ _ _ _ _ id itemH=:{wItemId`} tb
		= (identifyMaybeId id wItemId`,itemH,tb)


//	Change the state of the slider and handle proper feedback.

setsliderstates :: ![(Id,IdFun SliderState)] !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
setsliderstates id_fs wPtr wH`=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElements (setSliderState wMetrics wPtr clipRect) id_fs whItems` tb
=	({wH` & whItems`=itemHs},tb)
where
	setSliderState :: !OSWindowMetrics !OSWindowPtr !Rect ![(Id,IdFun SliderState)] !WItemHandle` !*OSToolbox
													  -> (![(Id,IdFun SliderState)],!WItemHandle`,!*OSToolbox)
	setSliderState wMetrics wPtr clipRect id_fs itemH=:{wItemKind`=IsCompoundControl} tb
		# (id_fs,itemHs,tb)	= setWElements (setSliderState wMetrics wPtr clipRect1) id_fs itemH.wItems` tb
		= (id_fs,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
	setSliderState wMetrics wPtr clipRect id_fs itemH=:{wItemId`,wItemKind`=IsSliderControl,wItemPtr`} tb
		| isNothing wItemId`
		= (id_fs,itemH,tb)
		# id				= fromJust wItemId`
		  (found,id_f,id_fs)= removeOnIdOfPair id id_fs
		| not found
		= (id_fs,itemH,tb)
		# info				= getWItemSliderInfo` itemH.wItemInfo`
		  oldState			= info.sliderInfoState`
		  (_,f)				= id_f
		  newState			= validateSliderState (f oldState)
		  itemH				= {itemH & wItemInfo`=SliderInfo` {info & sliderInfoState`=newState}}
		  (tbMin,tbThumb,tbMax,_)
		  					= toOSscrollbarRange (newState.sliderMin,newState.sliderThumb,newState.sliderMax) 0
		# tb				= OSsetSliderThumb wPtr wItemPtr` clipRect (not (IsEmptyRect clipRect)) (tbMin,tbThumb,tbMax) tb
		= (id_fs,itemH,tb)
	setSliderState _ _ _ id_fs itemH tb
		= (id_fs,itemH,tb)
/* Mac oswindow version.
OSsetSliderThumb :: !OSWindowPtr !OSWindowPtr !Rect !Bool !(!Int,!Int,!Int) !*OSToolbox -> *OSToolbox
OSsetSliderThumb parentWindow cPtr clipRect redraw (min,thumb,max) tb
	# (visRgn, tb)			= WindowGetVisRgn parentWindow tb
	# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
	# (port,rgn,font,tb)	= openDrawing parentWindow tb
	# tb					= QSetClip clipRgn tb
	# tb					= SetCtlValue cPtr thumb tb
	# tb					= HiliteControl cPtr (if (min<>max) 0 255) tb
	# tb					= closeDrawing port font rgn [rgn,clipRgn] tb
	= tb
*/

//	Selecting a RadioControl item.

selectradiocontrol :: !Id !Index !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
selectradiocontrol id index wPtr wH=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElement (selectWItemRadioControl wMetrics wPtr clipRect index) id whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	selectWItemRadioControl :: !OSWindowMetrics !OSWindowPtr !Rect !Index !Id !WItemHandle` !*OSToolbox -> (!Bool,!WItemHandle`,!*OSToolbox)
	
	selectWItemRadioControl wMetrics wPtr clipRect index id itemH=:{wItemKind`=IsCompoundControl} tb
		# (done,itemHs,tb)	= setWElement (selectWItemRadioControl wMetrics wPtr clipRect1 index) id itemH.wItems` tb
		= (done,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
	
	selectWItemRadioControl wMetrics wPtr clipRect index id itemH=:{wItemId`,wItemKind`} tb
		| wItemKind`<>IsRadioControl || not (identifyMaybeId id wItemId`)
		= (False,itemH,tb)
		# info				= getWItemRadioInfo` itemH.wItemInfo`
		  cur				= info.radioIndex`
		  items				= info.radioItems`
		  nrItems			= length items
		  index				= SetBetween index 1 nrItems
		  info				= {info & radioIndex`=index}
		  itemH				= {itemH & wItemInfo`=RadioInfo` info}
		| index==cur
		= (True,itemH,tb)
		# tb				= OSsetRadioControl wPtr (items!!(cur-1)).radioItemPtr` (items!!(index-1)).radioItemPtr` clipRect tb
		= (True,itemH,tb)
	/* Mac oswindow version.
	OSsetRadioControl :: !OSWindowPtr !OSWindowPtr !OSWindowPtr !Rect !*OSToolbox -> *OSToolbox
	OSsetRadioControl parentWindow curPtr newPtr clipRect tb
		# (visRgn, tb)			= WindowGetVisRgn parentWindow tb
		# (clipRgn,tb)			= IntersectRgnRect visRgn clipRect tb
		# (port,rgn,font,tb)	= openDrawing parentWindow tb
		# tb					= QSetClip clipRgn tb
		# tb					= SetCtlValue curPtr 0 tb
		# tb					= SetCtlValue newPtr 1 tb
		# tb					= closeDrawing port font rgn [rgn,clipRgn] tb
		= tb
	*/


//	Select a PopUpControl item.
	
selectpopupitem :: !Id !Index !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
selectpopupitem id index wPtr wH=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElement (selectWItemPopUp wMetrics wPtr True index clipRect) id whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	selectWItemPopUp :: !OSWindowMetrics !OSWindowPtr !Bool !Index !Rect !Id !WItemHandle` !*OSToolbox -> (!Bool,!WItemHandle`,!*OSToolbox)
	
	selectWItemPopUp wMetrics wPtr shownContext index clipRect id itemH=:{wItemKind`=IsCompoundControl} tb
		# (found,itemHs,tb)	= setWElement (selectWItemPopUp wMetrics wPtr shownContext1 index clipRect1) id itemH.wItems` tb
		= (found,{itemH & wItems`=itemHs},tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		clipRect1			= intersectRectContent wMetrics clipRect info itemH.wItemPos` itemH.wItemSize`
		shownContext1		= shownContext && itemH.wItemShow`
	
	selectWItemPopUp wMetrics wPtr shownContext index clipRect id itemH=:{wItemId`,wItemKind`} tb
		| wItemKind`<>IsPopUpControl || not (identifyMaybeId id wItemId`)
		= (False,itemH,tb)
		# info				= getWItemPopUpInfo` itemH.wItemInfo`
		  popUps			= info.popUpInfoItems`
		  curindex			= info.popUpInfoIndex`
		  nrPopUps			= length popUps
		  index				= SetBetween index 1 nrPopUps
		| curindex==index
		= (True,itemH,tb)
		# shownContext1		= shownContext && itemH.wItemShow`
		  info				= {info & popUpInfoIndex`=index}
		  itemH				= {itemH & wItemInfo`=PopUpInfo` info}
		  itemRect			= PosSizeToRect itemH.wItemPos` itemH.wItemSize`
		# tb				= OSsetPopUpControl wPtr itemH.wItemPtr` clipRect itemRect curindex index (popUps!!(index-1)) shownContext1 tb
		= (True,itemH,tb)
	/* Mac oswindow version.
	OSsetPopUpControl :: !OSWindowPtr !OSWindowPtr !Rect !Rect !Int !Int !String !Bool !*OSToolbox -> *OSToolbox
	OSsetPopUpControl parentWindow popupPtr clipRect itemRect current new text shown tb
		# tb				= CheckItem popupPtr current False tb
		# tb				= CheckItem popupPtr new     True  tb
		| not shown
		= tb
		# (visRgn, tb)		= WindowGetVisRgn parentWindow tb
		# (clipRgn,tb)		= IntersectRgnRect visRgn clipRect tb
		# (port,rgn,font,tb)= openDrawing parentWindow tb
		# tb				= QSetClip clipRgn tb
		# tb				= redrawPopUpItemText itemRect text tb
		# tb				= closeDrawing port font rgn [rgn,clipRgn] tb
		= tb
	*/


//	Move the ViewFrame of a CompoundControl. (In future version also customised controls.)

movecontrolviewframe :: !Id !Vector !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
movecontrolviewframe id v wPtr wH=:{whItems`,whSize`={w,h}} tb
	# (wMetrics,tb)			= OSDefaultWindowMetrics tb
	  clipRect				= getWindowContentRect wMetrics False False (0,0, w,h)
	# (_,itemHs,tb)			= setWElement (moveWItemFrame wMetrics wPtr True clipRect v) id whItems` tb
	= ({wH & whItems`=itemHs},tb)
where
	moveWItemFrame :: !OSWindowMetrics !OSWindowPtr !Bool !Rect !Vector !Id !WItemHandle` !*OSToolbox -> (!Bool,!WItemHandle`,!*OSToolbox)
	
	moveWItemFrame wMetrics wPtr shownContext clipRect v id itemH=:{wItemKind`} tb
		| wItemKind`<>IsCompoundControl
			= (False,itemH,tb)
		| not (identifyMaybeId id itemH.wItemId`)
			# (done,itemHs,tb)	= setWElement (moveWItemFrame wMetrics wPtr shownContext1 clipRect1 v) id itemH.wItems` tb
			= (done,{itemH & wItems`=itemHs},tb)
		# (minx,maxx,viewx)	= (domain.corner1.x,domain.corner2.x,contentSize.w)
		  (miny,maxy,viewy)	= (domain.corner1.y,domain.corner2.y,contentSize.h)
		  newOrigin			= {x=SetBetween (oldOrigin.x+v.vx) minx (maxx-viewx),y=SetBetween (oldOrigin.y+v.vy) miny (maxy-viewy)}
		  v					= toVector (newOrigin-oldOrigin)
		| v==zero
			= (True,itemH,tb)
		# tb				= setsliderthumb hasHScroll itemPtr True  (minx,newOrigin.x,maxx) viewx tb
		# tb				= setsliderthumb hasVScroll itemPtr False (miny,newOrigin.y,maxy) viewy tb
		# (itemHs,tb)		= movecontrolspos` (~v) wPtr itemPos itemH.wItems` tb
		# tb				= OSinvalidateWindow itemPtr tb
		  info				= {info & compoundOrigin=newOrigin}
		  itemH				= {itemH & wItems`=itemHs,wItemInfo`=CompoundInfo` info}
		= (True,itemH,tb)
	where
		info				= getWItemCompoundInfo` itemH.wItemInfo`
		domain				= info.compoundDomain
		oldOrigin			= info.compoundOrigin
		hasHScroll			= isJust info.compoundHScroll
		hasVScroll			= isJust info.compoundVScroll
		itemPtr				= itemH.wItemPtr`
		itemPos				= itemH.wItemPos`
		itemSize			= itemH.wItemSize`
		itemRect			= PosSizeToRect itemPos itemSize
		contentRect			= getCompoundContentRect wMetrics hasHScroll hasVScroll itemRect
		contentSize			= RectSize contentRect
		clipRect1			= IntersectRects contentRect clipRect
		shownContext1		= if shownContext itemH.wItemShow` shownContext
		
		setsliderthumb :: !Bool OSWindowPtr Bool (Int,Int,Int) Int !*OSToolbox -> *OSToolbox
		setsliderthumb hasScroll itemPtr isHScroll scrollValues viewSize tb
			| hasScroll
			= OSsetCompoundSliderThumb itemPtr isHScroll osThumb True tb
			= tb
		where
			(_,osThumb,_,_)	= toOSscrollbarRange scrollValues viewSize
